<?php
/**
 * Category second description
 *
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Get3addons extends Module
{
    protected $config_form = false;

    public function __construct()
    {
        $this->name = 'get3addons';
        $this->tab = 'administration';
        $this->version = '1.0.7';
        $this->author = 'get3code.com';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('CSS and JS addons');
        $this->description = $this->l('Add css and javascript files from the PrestaShop administration panel');
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        Configuration::updateValue('GET3ADDONS_LIVE_MODE', true);
        Configuration::updateValue('GET3ADDONS_DARK_THEME', false);
        Configuration::updateValue('GET3ADDONS_DATABASE', false);
        Configuration::updateValue('GET3ADDONS_CODEMIRROR', false);
        Configuration::updateValue('GET3ADDONS_CODEHEIGHT', 400);
        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('displayBackOfficeHeader') &&
            $this->registerHook('displayFooter') &&
            $this->registerHook('displayHeader');
    }

    public function uninstall()
    {
        Configuration::deleteByName('GET3ADDONS_LIVE_MODE');
        Configuration::deleteByName('GET3ADDONS_DARK_THEME');
        Configuration::deleteByName('GET3ADDONS_CODEMIRROR');
        Configuration::deleteByName('GET3ADDONS_DATABASE');
        Configuration::deleteByName('GET3ADDONS_CSS');
        Configuration::deleteByName('GET3ADDONS_JS_HEADER');
        Configuration::deleteByName('GET3ADDONS_JS_FOOTER');
        Configuration::deleteByName('GET3ADDONS_CODEHEIGHT');
        return parent::uninstall();
    }

    public function getContent()
    {
        if (((bool)Tools::isSubmit('submitGet3addonsModule')) == true) {
            $this->postProcess();
            $confirmations = $this->l('Successful update');
        }

        if (((bool)Tools::isSubmit('submitGet3CSS')) == true) {
            self::setCustomFile('css', Tools::getValue('GET3ADDONS_CSS'));
            $confirmations = $this->l('Successful update');
        }

        if (((bool)Tools::isSubmit('submitGet3JSHeader')) == true) {
            self::setCustomFile('js', Tools::getValue('GET3ADDONS_JS_HEADER'), 'header');
            $confirmations = $this->l('Successful update');
        }

        if (((bool)Tools::isSubmit('submitGet3JSFooter')) == true) {
            self::setCustomFile('js', Tools::getValue('GET3ADDONS_JS_FOOTER'), 'footer');
            $confirmations = $this->l('Successful update');
        }

        $urlModule = _PS_BASE_URL_.__PS_BASE_URI__.'modules/get3addons/';
        $this->context->smarty->assign('module_dir', $this->_path);

        if(isset($confirmations) && $confirmations != NULL) {
          $this->context->smarty->assign('confirmations', $confirmations);
        }


        if(Configuration::get('GET3ADDONS_DATABASE')) {
          $this->context->smarty->assign('css', Configuration::get('GET3ADDONS_CSS'));
          $this->context->smarty->assign('js_header', Configuration::get('GET3ADDONS_JS_HEADER'));
          $this->context->smarty->assign('js_footer', Configuration::get('GET3ADDONS_JS_FOOTER'));
        } else {
          $this->context->smarty->assign('css', self::getCustomFile('css'));
          $this->context->smarty->assign('js_header', self::getCustomFile('js','header'));
          $this->context->smarty->assign('js_footer', self::getCustomFile('js','footer'));
        }

        $this->context->smarty->assign('darkmode', Configuration::get('GET3ADDONS_DARK_THEME'));
        $this->context->smarty->assign('get3img', $urlModule.'views/img/get3code.webp');
        $this->context->smarty->assign('disableCodeMirror', Configuration::get('GET3ADDONS_CODEMIRROR'));
        $this->context->smarty->assign('codeHeight', Configuration::get('GET3ADDONS_CODEHEIGHT'));

        $output = $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');
        $notification_output = $this->context->smarty->fetch($this->local_path.'views/templates/admin/notification.tpl');
        return $notification_output.$this->renderForm().$output;
    }

    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitGet3addonsModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }


    protected function getConfigForm()
    {
        return array(
            'form' => array(
                'legend' => array(
                'title' => $this->l('Settings module'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Enable custom CSS / JS'),
                        'name' => 'GET3ADDONS_LIVE_MODE',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Editor dark mode'),
                        'name' => 'GET3ADDONS_DARK_THEME',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Disable CodeMirror editor'),
                        'name' => 'GET3ADDONS_CODEMIRROR',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Load from database'),
                        'name' => 'GET3ADDONS_DATABASE',
                        'is_bool' => true,
                        'desc' => $this->l('If you select this option - the data will be saved to the database. Remember that this is a good solution for a small amount of code.'),
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'col' => 3,
                        'prefix' => '<i>px</i>',
                        'name' => 'GET3ADDONS_CODEHEIGHT',
                        'label' => $this->l('Editor Height'),
                        'desc' => $this->l('Set your own code editor height.'),
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }

    protected function getConfigFormValues()
    {
        return array(
            'GET3ADDONS_LIVE_MODE' => Configuration::get('GET3ADDONS_LIVE_MODE'),
            'GET3ADDONS_DARK_THEME' => Configuration::get('GET3ADDONS_DARK_THEME'),
            'GET3ADDONS_CODEMIRROR' => Configuration::get('GET3ADDONS_CODEMIRROR'),
            'GET3ADDONS_DATABASE' => Configuration::get('GET3ADDONS_DATABASE'),
            'GET3ADDONS_CODEHEIGHT' => Configuration::get('GET3ADDONS_CODEHEIGHT'),
            'GET3ADDONS_CSS' => Configuration::get('GET3ADDONS_CSS', true),
            'GET3ADDONS_JS_HEADER' => Configuration::get('GET3ADDONS_JS_HEADER', true),
            'GET3ADDONS_JS_FOOTER' => Configuration::get('GET3ADDONS_JS_FOOTER', true)
        );
    }

    protected function postProcess()
    {
        Configuration::updateValue('GET3ADDONS_LIVE_MODE', Tools::getValue('GET3ADDONS_LIVE_MODE'));
        Configuration::updateValue('GET3ADDONS_DATABASE', Tools::getValue('GET3ADDONS_DATABASE'));
        Configuration::updateValue('GET3ADDONS_DARK_THEME', Tools::getValue('GET3ADDONS_DARK_THEME'));
        Configuration::updateValue('GET3ADDONS_CODEMIRROR', Tools::getValue('GET3ADDONS_CODEMIRROR'));
        Configuration::updateValue('GET3ADDONS_CODEHEIGHT', Tools::getValue('GET3ADDONS_CODEHEIGHT'));
    }

    public function hookDisplayBackOfficeHeader()
    {
        if (Tools::getValue('configure') == $this->name) {
            $this->context->controller->addJS($this->_path.'/views/js/codemirror.min.js');
            $this->context->controller->addJS($this->_path.'/views/js/css.min.js');
            $this->context->controller->addJS($this->_path.'/views/js/javascript.min.js');
            if(!Configuration::get('GET3ADDONS_CODEMIRROR')) {
              $this->context->controller->addJS($this->_path.'/views/js/back.js');
            }
            $this->context->controller->addCSS($this->_path.'/views/css/codemirror.min.css');
            $this->context->controller->addCSS($this->_path.'/views/css/monokai.min.css');
            $this->context->controller->addCSS($this->_path.'/views/css/back.css');
        }
    }

    public function hookHeader()
    {
        $this->context->controller->addJS($this->_path.'/views/js/front.js');
        $this->context->controller->addCSS($this->_path.'/views/css/front.css');
    }

    public function hookDisplayFooter()
    {
        if(Configuration::get('GET3ADDONS_LIVE_MODE')) {
          if(Configuration::get('GET3ADDONS_DATABASE')) {
            $this->context->smarty->assign('get3js_footer', Configuration::get('GET3ADDONS_JS_FOOTER'));
          } else {
            $this->context->smarty->assign('get3js_footer', self::getCustomFile('js','footer'));
          }

          return $this->display(__FILE__,'views/templates/front/addjs.tpl');
        }
    }

    public function hookDisplayHeader()
    {
        if(Configuration::get('GET3ADDONS_LIVE_MODE')) {
          if(Configuration::get('GET3ADDONS_DATABASE')) {
            $this->context->smarty->assign('get3css', Configuration::get('GET3ADDONS_CSS'));
            $this->context->smarty->assign('get3js_header', Configuration::get('GET3ADDONS_JS_HEADER'));
          } else {
            $this->context->smarty->assign('get3css', self::getCustomFile('css'));
            $this->context->smarty->assign('get3js_header', self::getCustomFile('js','header'));
          }

          return $this->display(__FILE__,'views/templates/front/addcss.tpl');
        }
    }

    public function getCustomFile($filename, $hook = null)
    {
      if($hook == null) {
        $module_file = fopen($this->local_path.'/views/'.$filename.'/custom.'.$filename ,'r');
      } else {
        $module_file = fopen($this->local_path.'/views/'.$filename.'/custom_'.$hook.'.'.$filename ,'r');
      }
      $module_file_content = fread($module_file, 999999);
      return $module_file_content;
    }

    public function setCustomFile($filename, $value, $hook = null)
    {
      if(Configuration::get('GET3ADDONS_DATABASE')) {
        Configuration::updateValue('GET3ADDONS_'.strtoupper($filename).'_'.strtoupper($hook), $value);
      } else {
        if($hook == null) {
          $module_file = fopen($this->local_path.'/views/'.$filename.'/custom.'.$filename ,'w');
        } else {
          $module_file = fopen($this->local_path.'/views/'.$filename.'/custom_'.$hook.'.'.$filename ,'w');
        }
        fwrite($module_file, $value);
      }
      return;
    }

}
