/**
* 2007-2023 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2023 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*/


window.addEventListener('DOMContentLoaded', function(){

  let theme = 'default';
  const darkMode = document.querySelector('#theme_get3').getAttribute('theme');
  if(darkMode == 1) theme = 'monokai';

  const js_header = document.querySelector('#GET3ADDONS_JS_HEADER');
  const js_footer = document.querySelector('#GET3ADDONS_JS_FOOTER');
  const css = document.querySelector('#GET3ADDONS_CSS');

  const codeCSS = CodeMirror(document.querySelector('#codeCSS'), {
    lineNumbers: true,
    tabSize: 2,
    value: css.value,
    mode: 'css',
    lineWrapping: true,
    theme: theme
  });

  const codeJS_header = CodeMirror(document.querySelector('#codeJSHeader'), {
    lineNumbers: true,
    tabSize: 2,
    value: js_header.value,
    mode: 'javascript',
    lineWrapping: true,
    theme: theme
  });

  const codeJS_footer = CodeMirror(document.querySelector('#codeJSFooter'), {
    lineNumbers: true,
    tabSize: 2,
    value: js_footer.value,
    mode: 'javascript',
    lineWrapping: true,
    theme: theme
  });

  document.querySelector('#codeCSS').addEventListener('keyup', function(){
    css.value = codeCSS.getValue();
  });
  document.querySelector('#codeJSHeader').addEventListener('keyup', function(){
    js_header.value = codeJS_header.getValue();
  });
  document.querySelector('#codeJSFooter').addEventListener('keyup', function(){
    js_footer.value = codeJS_footer.getValue();
  });

  //Show hide tab
  const tabs = document.querySelectorAll('.accordion-code');
  tabs.forEach((item) => {
    item.addEventListener('click', function(e){
      const target = e.target.getAttribute('data-for');
      if(e.target.innerText == 'SHOW') {
        e.target.innerText = 'HIDE';
        document.querySelector(target).classList.remove('hide-content');
      } else {
        e.target.innerText = 'SHOW';
        document.querySelector(target).classList.add('hide-content');
      }

    });
  })

});
